clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
x                   = -2:0.0001:2.0;                            %Diagrammbereich:    %Syntax: links: for-Startwert; Mitte = for-Inkrement; rechts: for-Abbruchbedingung
y                   = @(x) exp(-x)-cos(x);                      %Funktion:           %Syntax: Beispiel: y = @(x) x.^3-5*x+3; exponenten mit ".^", statt "^" schreiben; Schreibe "5*x", statt "5x"
Xu                  = 1.1;                                      %Modus Intervall: Untere Grenze neben Nullstelle: aus Plot ablesen
Xo                  = 1.6;                                      %Modus Intervall: Untere Grenze neben Nullstelle: aus Plot ablesen
Modus               = 2;                                        %1 = Abbruchbedingung: exakte Nullstelle
                                                                %2 = Abbruchbedingung: Nachkommastelle (Vergleich Werte xu xo)
                                                                %3 = Abbruchbedingung: relativer Fehler
                                                                %4 = Abbruchbedingung: Genauigkeit
Nachkommastelle     = 12;
Relativer_Fehler    = 10^-4;                                    %Angabe nicht in Prozent sondern dezimal -> Maximum ist 1
Genauigkeit         = 0.01;                                     %Angabe nicht in Prozent sondern dezimal -> Maximum ist 1   ???SCHWEINESCHEIE
sKommastellenDouble = '%.20f';                                  %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%FUNKTIONSPLOT---------------------------------------------------------------------
xACHSE          = @(x) 0*x;
plot(x,y(x),'color','blue');
hold on;                                %Warten bis zur Plotausgabe
plot(x,xACHSE(x),'color','black');
grid on;
grid minor;

%EINGABEBEREICH--------------------------------------------------------------------
fprintf('%s\n',"Tragen Sie die Funktion in den Header des Skriptes ein!")
fprintf('%s\n',"Betrachten Sie den Plot der Funktion!")
fprintf('%s\n',"Quadratische Funktionen und Funktionen mit Sprung knnen Probleme erzeugen!")
fprintf('%s\n',"Whlen Sie eine Nullstelle um die sie eine Grenze ziehen mchten!")
fprintf('%s\n\n',"__________________________________________________________________");

%BERECHNUNG------------------------------------------------------------------------
aTABELLE=["i","Xu","Xo","Xm","f(Xm)","f(Xu)*f(Xm)"];                                %Kopfzeile Mixed-Array

switch(Modus)
    case 1
        i=0;
        while(1)
            Xm=(Xu+Xo)/2;
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xu,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xo,sKommastellenDouble);
            aTABELLE(i+2,4)=num2str(Xm,sKommastellenDouble);
            aTABELLE(i+2,5)=num2str(y(Xm),sKommastellenDouble);
            if(y(Xu)*y(Xm)<0)
                aTABELLE(i+2,6)="<0";
                Xo=Xm;
            elseif(y(Xu)*y(Xm)>0)
                aTABELLE(i+2,6)=">0";
                Xu=Xm;
            else
                aTABELLE(i+2,6)="=0";
                break;                                                              %Wenn ditt mal ditt = 0 -> Nullstelle gefunden
            end
            i=i+1;
        end
        fprintf('%s\n',"Berechnung abgebrochen, weil y(Xu)*y(Xm) = 0");
        
    case 2
        i_max=ceil(1+((Nachkommastelle+log10(abs(Xo-Xu)))/(log10(2))));                      %Anzahl ntiger Iterationsschritte
        for(i=0:1:(i_max-1))
            Xm=(Xu+Xo)/2;
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xu,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xo,sKommastellenDouble);
            aTABELLE(i+2,4)=num2str(Xm,sKommastellenDouble);
            aTABELLE(i+2,5)=num2str(y(Xm),sKommastellenDouble);
            if(y(Xu)*y(Xm) < 0)
                aTABELLE(i+2,6)="<0";
                Xo=Xm;
            elseif(y(Xu)*y(Xm) > 0)
                aTABELLE(i+2,6)=">0";
                Xu=Xm;
            else
                aTABELLE(i+2,6)="=0";
                break;                                                              %Wenn ditt mal ditt = 0 -> Nullstelle gefunden
            end
        end
        fprintf('Anzahl ntiger Interationsschritte fr %u Nachkommastellen: i = %u\n',Nachkommastelle,i_max);
        
    case 3
        i=0;
        Xm_alt=0;
        while(1)
            Xm=(Xu+Xo)/2;
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xu,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xo,sKommastellenDouble);
            aTABELLE(i+2,4)=num2str(Xm,sKommastellenDouble);
            aTABELLE(i+2,5)=num2str(y(Xm),sKommastellenDouble);
            if(y(Xu)*y(Xm)<0)
                aTABELLE(i+2,6)="<0";
                Xo=Xm;
            elseif(y(Xu)*y(Xm)>0)
                aTABELLE(i+2,6)=">0";
                Xu=Xm;
            else
                aTABELLE(i+2,6)="=0";
                break;                                                              %Wenn ditt mal ditt = 0 -> Nullstelle gefunden
            end
            if(abs((Xm-Xm_alt)/Xm) < abs(Relativer_Fehler))
                break; 
            end
            Xm_alt=Xm;                                                              %Zeile mit Xm_alt muss unbedingt nach if-Anweisung kommen
            i=i+1;
        end
        fprintf('Berechnung abgebrochen, weil |(Xm-Xm_alt)/Xm| kleiner als |zulssiger relativer Fehler| %f < %f\n',abs((Xm-Xm_alt)/Xm),abs(Relativer_Fehler));
        
    case 4
        i=0;
        while(1)
            Xm=(Xu+Xo)/2;
            aTABELLE(i+2,1)=i;
            aTABELLE(i+2,2)=num2str(Xu,sKommastellenDouble);
            aTABELLE(i+2,3)=num2str(Xo,sKommastellenDouble);
            aTABELLE(i+2,4)=num2str(Xm,sKommastellenDouble);
            aTABELLE(i+2,5)=num2str(y(Xm),sKommastellenDouble);
            if(y(Xu)*y(Xm)<0)
                aTABELLE(i+2,6)="<0";
                Xo=Xm;
            elseif(y(Xu)*y(Xm)>0)
                aTABELLE(i+2,6)=">0";
                Xu=Xm;
            else
                aTABELLE(i+2,6)="=0";
                break;                                                              %Wenn ditt mal ditt = 0 -> Nullstelle gefunden
            end
            if(abs(Xo-Xu)/(2^i) < Genauigkeit) 
                break;
            end
            i=i+1;
        end
        fprintf('Berechnung abgebrochen, weil |(Xo-Xu)/(2^i)| kleiner als erforderliche Genauigkeit: %f < %f\n',abs(Xo-Xu)/(2^i),Genauigkeit);
          
    otherwise
        fprintf('%s\n','Variable "Modus" nicht definiert!');
end

%AUSGABE----------------------------------------------------------------------------
fprintf('%s\n\n',"__________________________________________________________________");
disp(aTABELLE);

%PROGRAMMENDE-----------------------------------------------------------------------
clearvars -except aTABELLE                                                           %Workspace aufrumen